<?php 
	global $woocommerce;
	$number    		= isset( $instance['numberposts'] ) ? intval($instance['numberposts']) : 5;
	$el_class  = isset( $instance['el_class'] )    ? 	strip_tags($instance['el_class']) : '';
	$query_args = array(
    		'posts_per_page' => $number,
    		'post_status' 	 => 'publish',
    		'post_type' 	 => 'product',
    		'meta_key' 		 => 'total_sales',
    		'orderby' 		 => 'meta_value_num',
    		'no_found_rows'  => 1,
    	);

    	$query_args['meta_query'] = $woocommerce->query->get_meta_query();

    	if ( isset( $instance['hide_free'] ) && 1 == $instance['hide_free'] ) {
    		$query_args['meta_query'][] = array(
			    'key'     => '_price',
			    'value'   => 0,
			    'compare' => '>',
			    'type'    => 'DECIMAL',
			);
    	}
$i = 0;
$pf_id = 'best-seller-'.rand().time();
		$r = new WP_Query($query_args);
		if ( $r->have_posts() ) {
?>
<div id="<?php echo esc_attr( $pf_id ) ?>" class="sw-best-seller-product carousel slide vc_element <?php echo esc_attr( $el_class ) ?>" data-interval="0">
	<?php if($title != ''){ ?>
	<div class="block-title <?php echo esc_attr( $style_title ) ?>">
	<?php if($style_title == 'title3'){
	$wordChunks = explode(" ", $title);
	$firstchunk = $wordChunks[0];
	$secondchunk = $wordChunks[1];
	?>
<h2> <span><?php echo esc_attr( $firstchunk ) ?></span> <span class="text-color"><?php echo $secondchunk ?> </span></h2>
<?php }else{ ?>
<h2>
   <span><?php echo $title ?></span>
</h2>
<?php     }
} ?>
	<div class="customNavigation nav-left-product">
				<a title="Previous" class="btn-bs prev-bs fa fa-angle-left"  href="#<?php echo esc_attr( $pf_id ) ?>" role="button" data-slide="prev"></a>
				<a title="Next" class="btn-bs next-bs fa fa-angle-right" href="#<?php echo esc_attr( $pf_id ) ?>" role="button" data-slide="next"></a>
			</div>
		</div>
    <div class="carousel-inner">
		<?php while ( $r -> have_posts() ) : $r -> the_post();
		global $product, $post, $wpdb, $average;
		$count = $wpdb->get_var($wpdb->prepare("
			SELECT COUNT(meta_value) FROM $wpdb->commentmeta
			LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
			WHERE meta_key = 'rating'
			AND comment_post_ID = %d
			AND comment_approved = '1'
			AND meta_value > 0
		",$post->ID));
		$rating = $wpdb->get_var($wpdb->prepare("
			SELECT SUM(meta_value) FROM $wpdb->commentmeta
			LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
			WHERE meta_key = 'rating'
			AND comment_post_ID = %d
			AND comment_approved = '1'
		",$post->ID));
	if( $i % 4 == 0 ){
    $active = ( $i == 0 ) ? 'active' : ''?>		
	<div class="item <?php echo $active ?>" >
	<?php } ?>
	<div class="bs-item cf">
	<div class="bs-item-inner">
	<div class="item-img">
    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>">
					<?php if( has_post_thumbnail() ){  
						echo (get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' )) ? get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' ):'<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
					}else{ 
						echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
					} ?>
	</a>
	</div>
	<div class="item-content">
	<?php
					if( $count > 0 ){
						$average = number_format($rating / $count, 1);
				?>
				
	<div class="star"><span style="width: <?php echo ($average*14).'px'; ?>"></span></div>
		<?php } else { ?>
				
					<div class="star"></div>
					
				<?php } ?>
	<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php the_title(); ?></a></h4>
      <p><?php echo $product->get_price_html(); ?></p>
	</div></div></div>
		<?php if( ( $i+1 )%4==0 || ( $i+1 ) == $number ){?> </div><?php } ?>
		<?php $i++; endwhile; wp_reset_postdata(); ?>
		</div></div>

<?php } ?>
