<?php 
	$number    		= isset( $instance['numberposts'] ) ? intval($instance['numberposts']) : 5;
	global $wpdb;
	global $post;
?>
<?php do_action( 'before' ); ?>
<?php if ( !class_exists( 'WooCommerce' ) ) { 
	return "Please active woocommerce plugin first!";
}

	$args = array( 'post_type' => 'product', 'posts_per_page' => $number );
	$args['meta_query'] = array();					
	$args['meta_query'][] = array(
		'key' => '_featured',
		'value' => 'yes'
	);

	$loop = new WP_Query( $args );
	$i = 0;
	$j = 0;
	$k = 0;
	
if ( $loop->have_posts() ) {
?>
<div id="<?php echo $widget_id; ?>" class="sw-feature-product">
	<ul class="list-unstyled">
	<?php
		while ( $loop -> have_posts() ) : $loop -> the_post();
		global $product, $post, $wpdb, $average;
		$count = $wpdb->get_var($wpdb->prepare("
			SELECT COUNT(meta_value) FROM $wpdb->commentmeta
			LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
			WHERE meta_key = 'rating'
			AND comment_post_ID = %d
			AND comment_approved = '1'
			AND meta_value > 0
		",$post->ID));

		$rating = $wpdb->get_var($wpdb->prepare("
			SELECT SUM(meta_value) FROM $wpdb->commentmeta
			LEFT JOIN $wpdb->comments ON $wpdb->commentmeta.comment_id = $wpdb->comments.comment_ID
			WHERE meta_key = 'rating'
			AND comment_post_ID = %d
			AND comment_approved = '1'
		",$post->ID));
	?>
		<li class="clearfix">
			<div class="item-img">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>">
					<?php if( has_post_thumbnail() ){  
						echo (get_the_post_thumbnail( $loop->post->ID, 'shop_thumbnail' )) ? get_the_post_thumbnail( $loop->post->ID, 'shop_thumbnail' ) : '<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
					}else{ 
						echo '<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
					} ?>
				</a>
			</div>
			<div class="item-content">
				<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php the_title(); ?></a></h4>
                <p><?php echo $product->get_price_html(); ?></p>
				<?php
					if( $count > 0 ){
						$average = number_format($rating / $count, 1);
				?>
					<div class="star"><span style="width: <?php echo ($average*13).'px'; ?>"></span></div>
					
				<?php } else { ?>
				
					<div class="star"></div>
					
				<?php } ?>

				<div class="review">
					<span><?php echo $count; ?> <?php esc_html_e(' review(s) ', 'shoppystore'); ?></span>
				</div>
			</div>
		</li>
	<?php 
		endwhile;
		wp_reset_postdata();
	?>
	</ul>
</div>
<?php } ?>
