<?php
/**
 * Plugin Name: Wordpress Less
 * Plugin URI: http://smartaddons.com
 * Description: Compile css from admin
 * Version: 4.0.0
 * Author: smartaddons.com
 * Author URI: http://smartaddons.com
 *
*/
add_action( 'wp', 'ya_lessphp', 20 );
function ya_lessphp(){
	require_once ( plugin_dir_path( __FILE__ ).'/3rdparty/lessc.inc.php' ); 

	if ( class_exists('lessc') && function_exists( 'ya_options' ) && ya_options()->getCpanelValue('developer_mode') ){
		$color 			 =  ya_options()->getCpanelValue('scheme_color');
		$bd_color 	 =  ya_options()->getCpanelValue('scheme_body');
		$bdr_color 	 =  ya_options()->getCpanelValue('scheme_border');
		$include_css =  ya_options()->getCpanelValue('include_css');
		
		define('LESS_PATH', get_template_directory().'/assets/less');
		define('CSS__PATH', get_stylesheet_directory().'/css');
		
		$scheme_meta = get_post_meta( get_the_ID(), 'scheme', true );
		$scheme = ( $scheme_meta != '' && $scheme_meta != 'none' ) ? $scheme_meta : ya_options()->getCpanelValue('scheme');
		$page_metabox_hometemp = get_post_meta( get_the_ID(), 'page_home_template', true );

		$scheme_vars = get_template_directory().'/templates/presets/default.php';
		$output_cssf = CSS__PATH.'/app-default.css';
		if ( $scheme && file_exists(get_template_directory().'/templates/presets/'.$scheme.'.php') ){
			$scheme_vars = get_template_directory().'/templates/presets/'.$scheme.'.php';
			$output_cssf = CSS__PATH."/app-{$scheme}.css";
			$output_cssf_page = CSS__PATH."/{$page_metabox_hometemp}-{$scheme}.css";
			$output_cssf_index = CSS__PATH."/homepage-{$scheme}.css";
		}
		if ( file_exists($scheme_vars)){
			include $scheme_vars;
			if( $color != '' ){
				$less_variables['color'] = $color;
			}
			if(  $bd_color != '' ) {
				$less_variables['body-color'] = $bd_color;
			}
			if(  $bdr_color != '' ){
				$less_variables['border-color'] = $bdr_color;
			}
			
			try {
				
				$less = new lessc();
				
				
				$less->setImportDir( array(LESS_PATH.'/app/', LESS_PATH.'/bootstrap/') );
				
				$less->setVariables($less_variables);
				
				$cache = $less->cachedCompile(LESS_PATH.'/app.less');
				file_put_contents($output_cssf, $cache["compiled"]);
				if( $page_metabox_hometemp !='' ) {
					$cache = $less->cachedCompile(LESS_PATH.'/'.$page_metabox_hometemp.'.less');
					file_put_contents($output_cssf_page, $cache["compiled"]);
				}
				
				if( $include_css ) {
					$cache = $less->cachedCompile(LESS_PATH.'/index.less');
					file_put_contents( $output_cssf_index, $cache["compiled"] );
				}
				
				/* RTL Language */
				$rtl_cache = $less->cachedCompile(LESS_PATH.'/app/rtl.less');
				file_put_contents(get_stylesheet_directory().'/css/rtl.css', $rtl_cache["compiled"]);
				
				$responsive_cache = $less->cachedCompile(LESS_PATH.'/app-responsive.less');
				file_put_contents(get_stylesheet_directory().'/css/app-responsive.css', $responsive_cache["compiled"]);
			} catch (Exception $e){
				var_dump($e); exit;
			}
		}
	}
}