<?php 
if ( ! defined( 'ABSPATH' ) ) { 
    exit; 
}

if( class_exists( 'Vc_Manager' ) ){
	require_once ( WCPATH . '/includes/visual-map.php' );
}

/*
** Accordion Product
*/
function ya_accordion_recommend_product_shortcode( $atts ) {
			extract( shortcode_atts( array(
			'title'         =>'',
			'orderby' => 'date',
			'order' => 'DESC',
			'numberposts'	=> 5,
			'el_class' =>'',
			), $atts )
		);
	ob_start();
	$default = array(
		'post_type' => 'product',
		'orderby' => $orderby,
		'order' => $order,
		'meta_key'		=> 'recommend_product',
		'meta_value'	=> 'yes',
		'post_status' => 'publish',
		'showposts' => $numberposts
	);
$i=0;
$list = new WP_Query( $default );
ob_start();		
		if ( count($list) > 0 ){ ?>
	
		<div class="panel-group accordion_recommend_product" id="accordion">
				<?php if( $title != ''){ ?>
			<div class="block-title">
				<strong>
					<span><?php echo $title ?></span>
				</strong>
				<div class="sn-img icon-bacsic2"></div>
			</div>
			<?php } ?>
			<?php while($list->have_posts()): $list->the_post();global $product, $post, $wpdb, $average;
			  $i++
			?>
		  <div class="panel panel-default">
		  
			<?php $att = ($i != '1') ? 'class="collapsed"': 'class=""'?>
				<a data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo $i ?> " <?php echo $att?>>
					<span class="item-count">
						 <?php echo $i ?>
					</span>
					 <h4 class="panel-title">
					 <?php the_title(); ?>
					 </h4>
				</a>
			<?php $attributes = ($i == '1') ? 'class="panel-collapse collapse in"': 'class="panel-collapse collapse"'?>
			<div id="collapse<?php echo $i ?>" <?php echo $attributes ?>>
				<div class="panel-body">
					<div class="item-content">
					<?php if(has_post_thumbnail()){ ?>
						<div class="item-img item-height">
							<div class="item-img-info products-thumb">
								<a href="<?php the_permalink();?>" title="<?php the_title_attribute();?>">
									<?php echo woocommerce_get_product_thumbnail('thumbnail') ?>
								</a>
							</div>
						</div>
					<?php } ?>
						<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute();?>"><?php the_title(); ?></a></h4>
						<!-- rating  -->
						<?php 
							$rating_count = $product->get_rating_count();
							$review_count = $product->get_review_count();
							$average      = $product->get_average_rating();
						?>
						<div class="reviews-content">
							<div class="star"><?php echo ( $average > 0 ) ?'<span style="width:'. ( $average*14 ).'px"></span>' : ''; ?></div>
							<div class="item-number-rating">
								<?php echo $review_count; _e(' Review(s)', 'sw_woocommerce');?>
							</div>
						</div>	
						<!-- end rating  -->
						<?php if ( $price_html = $product->get_price_html() ){?>
						<div class="item-price">
							<span>
								<?php echo $price_html; ?>
							</span>
						</div>
						<?php } ?>
					</div>	
				</div>
			</div>
		  </div>
		<?php endwhile; wp_reset_postdata();?>
	</div>
	<?php } 
	$content = ob_get_clean();
		
		return $content;
}
add_shortcode('accordion_recommend_product','ya_accordion_recommend_product_shortcode');
/*
** Recommend Product
*/
wp_reset_postdata();
function ya_recommend_product_shortcode( $atts ) {
			extract( shortcode_atts( array(
			'title'         =>'',
			'columns'       => 2,
			'category_id'      =>'', 
			'orderby' => 'date',
			'order' => 'DESC',
			'numberposts'	=> 5,
			'el_class' =>'',
			), $atts )
		);
	ob_start();
if( $category_id != '' ){
	$default = array(
		'post_type'		=> 'product',
		'orderby' => $orderby,
		'order' => $order,
		'tax_query' => array(
			array(
				'taxonomy'	=> 'product_cat',
				'field'		=> 'slug',
				'terms'		=> $category_id,
				'operator' 	=> 'IN'
			)
		),
	    'meta_key'		=> 'recommend_product',
		'meta_value'	=> 'yes',
		'post_status' => 'publish',
		'showposts' => $numberposts				
	);
}else{
	$default = array(
		'post_type' => 'product',
		'orderby' => $orderby,
		'order' => $order,
		'meta_key'		=> 'recommend_product',
		'meta_value'	=> 'yes',
		'post_status' => 'publish',
		'showposts' => $numberposts
	);
}
$i=0;
global $woocommerce_loop;
$id = 'sw_recommend_'.rand().time();
$list = new WP_Query( $default );
$woocommerce_loop['columns'] = $columns;

ob_start();	
?>
<div class="box-slider-title">
     <h2><span><?php echo esc_html__( $title,'sw_woocommerce' ) ?></span></h2>
	 <div class="catslide-more">
	    <a href="<?php echo get_site_url('','/?post_type=product',''); ?>" title="" target="_blank"><?php esc_html_e( 'View all', 'sw_woocommerce' ); ?></a>
	 </div>
</div>
<?php
		if ( count($list) > 0 ){ ?>
<?php woocommerce_product_loop_start(); ?>
				<?php while($list->have_posts()): $list->the_post();global $product, $post, $wpdb, $average; ?>

					<?php include( WCTHEME.'/content-product.php' ); ?>

				<?php endwhile; ?>

			<?php woocommerce_product_loop_end(); ?>
	    <?php } woocommerce_reset_loop();
		wp_reset_postdata();
$content = ob_get_clean();
return '<div class="woocommerce '.$id.' columns-' . $columns . '"><div class="row">' . $content. '</div></div>';
}
add_shortcode('recommend_products','ya_recommend_product_shortcode');
/*
** Toprate Product
*/
wp_reset_postdata();
function ya_toprate_product_shortcode( $atts ) {
			extract( shortcode_atts( array(
			'title'         =>'',
			'columns'       => '',
			'category_id'   =>'',
			'numberposts'	=> '',
			'el_class' =>'',
			), $atts )
		);
	ob_start();
if( $category_id != '' ){
	$default = array(
		'post_type'		=> 'product',
		'tax_query' => array(
			array(
				'taxonomy'	=> 'product_cat',
				'field'		=> 'slug',
				'terms'		=> $category_id,
				'operator' 	=> 'IN'
			)
		),
		'post_status' 	=> 'publish',
		'no_found_rows' => 1,					
		'showposts' 	=> $numberposts						
	);
}else{
	$default = array(
		'post_type'		=> 'product',		
		'post_status' 	=> 'publish',
		'no_found_rows' => 1,					
		'showposts' => $numberposts				
	);
}
if( sw_woocommerce_version_check( '2.7' ) ){
	$default['meta_key'] = '_wc_average_rating';
	$default['orderby'] = 'meta_value_num';
}else{
	add_filter( 'posts_clauses',  array( WC()->query, 'order_by_rating_post_clauses' ) );
}

$i=0;
global $woocommerce_loop;
$id = 'sw_toprated_'.rand().time();
$list = new WP_Query( $default );
$woocommerce_loop['columns'] = $columns;
ob_start();	
?>
<div class="box-slider-title">
     <h2><span><?php echo esc_html__( $title,'sw_woocommerce' ) ?></span></h2>
	 <div class="catslide-more">
	    <a href="<?php echo get_site_url('','/?post_type=product',''); ?>" title="" target="_blank"><?php esc_html_e( 'View all', 'sw_woocommerce' ); ?></a>
	 </div>
</div>
<?php
		if ( count($list) > 0 ){ ?>
<?php woocommerce_product_loop_start(); ?>
				<?php while($list->have_posts()): $list->the_post();global $product, $post, $wpdb, $average; ?>

					<?php include( WCTHEME.'/top-rated.php' ); ?>

				<?php endwhile; ?>

			<?php woocommerce_product_loop_end(); ?>
	    <?php } woocommerce_reset_loop();
		wp_reset_postdata();
$content = ob_get_clean();
return '<div class="woocommerce '.$id.' columns-' . $columns . '"><div class="row">' . $content. '</div></div>';
}
add_shortcode('toprate','ya_toprate_product_shortcode');


/*
** Listing tab product
*/
function ya_listing_product_tab( $atts ){
	extract( shortcode_atts( array(
		'categories'	=> '',
		'orderby' => 'date',
		'order' => 'DESC',
		'number'	=> 5,
		'columns' => 5
		), $atts )
	);
	ob_start();		
	global $yith_wcwl,$product;
	$rand_time = rand().time();
	$lf_id = 'listing_tab_'.rand().time();
	$categories_id = array();
	if( $categories != '' ){
		$categories_id = preg_split( '/[\s,]/', $categories );
	}
	if( count( $categories_id ) < 1 ){
		return ;
	}
	$attributes = '';
	$attributes .= 'tab-col-'.$number;
?>
	<div id="<?php echo esc_attr( $lf_id ) ?>" class="listing-tab-shortcode">
		<div class="tabbable tabs">
			<ul id="<?php echo esc_attr( 'myTabs_'.$rand_time ) ?>" class="nav nav-tabs">
			<?php 
				foreach( $categories_id as $key => $category_id ){
					$cat = get_term_by('id', $category_id, 'product_cat');
					if( $cat ){
					$active = ( $key == 0 ) ? 'active' : '';
			?>
				<li class="<?php echo esc_attr( $active ) ?>" onclick="window.location=&#39;<?php echo get_term_link( intval($category_id), 'product_cat' ) ?>&#39;"><a href="<?php echo esc_attr( '#listing_category_'.$category_id ) ?>" data-toggle="tabs"><?php echo esc_html( $cat -> name ) ?></a></li>
				<?php	} } ?>
			</ul>
			<div class="tab-content">
			<?php 
			foreach( $categories_id as $key => $category_id ){
				$active = ( $key == 0 ) ? 'active' : '';
			?>
				<div id="<?php echo esc_attr( 'listing_category_'.$category_id ) ?>" class="tab-pane clearfix <?php echo esc_attr( $active ) ?>">
				<?php 
					if( $category_id != 0 ){
					$args = array(
						'post_type' => 'product',
						'tax_query'	=> array(
						array(
							'taxonomy'	=> 'product_cat',
							'field'		=> 'id',
							'terms'		=> $category_id)),
						
						'orderby'		=> $orderby,
						'order'			=> $order,
						'post_status' 	=> 'publish',
						'showposts' 	=> $number
					);
					}else{
						$args = array(
							'post_type' => 'product',
							'orderby' => $orderby,
							'order' => $order,
							'post_status' => 'publish',
							'showposts' => $number
						);
					}
					$list = new WP_Query( $args );
					
					while($list->have_posts()): $list->the_post();global $product, $post, $wpdb, $average;
				?>
					<div class="item">
						<div class="item-wrap">
							<div class="item-detail">
								<div class="item-img products-thumb">			  
									<?php do_action( 'woocommerce_before_shop_loop_item_title' );  ?>														
								</div>
								<div class="item-content">
									<?php $average      = $product->get_average_rating(); ?>
									<div class="reviews-content">
										<div class="star"><?php echo ( $average > 0 ) ?'<span style="width:'. ( $average*14 ).'px"></span>' : '' ?> </div>		
									</div>
									<h4><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h4>
									<?php if ( $price_html = $product->get_price_html() ){ ?>
										<div class="item-price"><span><?php echo $price_html ?></span></div>
									<?php } ?>
									<div class="item-bottom-grid clearfix">
									<?php woocommerce_template_loop_add_to_cart(); ?>
									<?php
										if ( class_exists( 'YITH_WCWL' ) ){
											echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
										} 
									?>		
									<?php if ( class_exists( 'YITH_WOOCOMPARE' ) ){ ?>
										<div class="woocommerce product compare-button">
											<a href="javascript:void(0)" class="compare button"  title="<?php esc_html_e( 'Add to Compare', 'sw_woocommerce' ) ?>" data-product_id="<?php echo esc_attr($post->ID); ?>" rel="nofollow"> <?php esc_html('compare','sw-woocomerce'); ?></a>	
										</div>
									<?php } ?>								
									</div>
								</div>
							</div>
						</div>
					</div>
			<?php 
				endwhile; wp_reset_postdata();
				wp_reset_postdata();
			?>
				</div>
			<?php  } ?>
			</div>
		</div>
	</div>
<?php 
	$content = ob_get_clean();
	return $content;
}
add_shortcode('product_tab','ya_listing_product_tab');

/*
* Best Sale product
*
*/
function yt_bestsale_shortcode($atts){
	extract(shortcode_atts(array(
		'number' => 5,
		'title'=>'Best Sale',
		'style_title'=>'title1',
		'el_class'=>'',
		'template'=>'',
		'post_status' 	 => 'publish',
		'post_type' 	 => 'product',
		'meta_key' 		 => 'total_sales',
		'orderby' 		 => 'meta_value_num',
		'no_found_rows'  => 1
	),$atts));
	global $woocommerce;
	$i='';
	$pf_id = 'bestsale-'.rand().time();
	$query_args = array( 'posts_per_page'=> $number,'post_type' => 'product','meta_key' => 'total_sales','orderby' => 'meta_value_num','no_found_rows' => 1); 
	$query_args['meta_query'] = $woocommerce->query->get_meta_query();

	$query_args['meta_query'][] = array(
		'key'     => '_price',
		'value'   => 0,
		'compare' => '>',
		'type'    => 'DECIMAL',
	);
	$r = new WP_Query($query_args);
	$numb_post = count( $r -> posts );
	if ( $r->have_posts() ) {
		if($template== 'default'){
			$output ='<div class="block-title-bottom">
			<h2>'.$title.'</h2>
			</div>';
			$output .='<div id="'.$pf_id.'" class="sw-best-seller-product vc_element">';
			while ( $r -> have_posts() ) : $r -> the_post();
			global $product, $post, $wpdb, $average;
				$rating_count = $product->get_rating_count();
				$review_count = $product->get_review_count();
				$average      = $product->get_average_rating();
				$output.='<div class="bs-item cf">
				<div class="bs-item-inner">';
				$output.='<div class="item-img">';
				$output.='<a href="'.post_permalink($post->ID).'" title="'.esc_attr( $post->post_title ).'">';
				if( has_post_thumbnail() ){  
					$output.= (get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' )) ? get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' ):'<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
				}else{ 
					$output.= '<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
				} 
				$output.='</a>';
				$output.='</div>';
				$output.='<div class="item-content">';
				$output.= '<div class="star">'.( $average > 0 ) ?'<span style="width:'. ( $average*14 ).'px"></span>' : ''. '</div>';
				$output.='<h4><a href="'.post_permalink($post->ID).'" title="'.esc_attr( $post->post_title ).'">'.esc_html( $post->post_title ).'</a></h4>';
				$output.= '<p>'.$product->get_price_html().'</p>';			 
				$output.='</div></div></div>';
			endwhile;
			wp_reset_postdata();
			$output.='</div>';
			return $output;
		}elseif($template == 'slide'){
			$output ='<div id="'.$pf_id.'" class="sw-best-seller-product vc_element carousel slide '.$el_class.'" data-interval="0">';
			if($title != ''){
				$output.='<div class="block-title '.$style_title.'">';
				$titles = strpos($title, ' ');
				$title = ($titles !== false && $style_title== 'title3' ) ? '<span>' . substr($title, 0, $titles) . '</span>' .' <span class="text-color">'. substr($title, $titles + 1).'</span>': '<span>'.$title.'</span>' ;
				$output .= '<h2>'. $title .'</h2>';    
			}
			$output.='<div class="customNavigation nav-left-product">
			<a title="Previous" class="btn-bs prev-bs fa fa-angle-left"  href="#'.$pf_id.'" role="button" data-slide="prev"></a>
			<a title="Next" class="btn-bs next-bs fa fa-angle-right" href="#'.$pf_id.'" role="button" data-slide="next"></a>
			</div>
			</div>';
			$output.='<div class="carousel-inner">';
			while ( $r -> have_posts() ) : $r -> the_post();
			global $product, $post, $wpdb, $average;
			$rating_count = $product->get_rating_count();
			$review_count = $product->get_review_count();
			$average      = $product->get_average_rating();
			if( $i % 4 == 0 ){
				$active = ( $i == 0 ) ? 'active' : '';		
				$output.='<div class="item '.$active.'" >';
			}
			$output.='<div class="bs-item cf">';
			$output.='<div class="bs-item-inner">';
			$output.='<div class="item-img">';
			$output.='<a href="'.post_permalink($post->ID).'" title="'.esc_attr( $post->post_title ).'">';
			if( has_post_thumbnail() ){  
				$output.= (get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' )) ? get_the_post_thumbnail( $r->post->ID, 'shop_thumbnail' ):'<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
			}else{ 
				$output.= '<img src="'.get_template_directory_uri().'/assets/img/placeholder/shop_thumbnail.png" alt="No thumb"/>' ;
			} 
			$output.='</a>';
			$output.='</div>';
			$output.='<div class="item-content">';
			$output.= '<div class="star">'.( $average > 0 ) ?'<span style="width:'. ( $average*14 ).'px"></span>' : ''. '</div>';
			$output.='<h4><a href="'.post_permalink($post->ID).'" title="'.esc_attr( $post->post_title ).'">'.esc_html( $post->post_title ).'</a></h4>';
			$output.= '<p>'.$product->get_price_html().'</p>';
			$output.='</div></div></div>';
			if( ( $i+1 ) % 4 == 0 || ( $i+1 ) == $numb_post ){
				$output.='</div>';
			}
			$i++;endwhile;
			wp_reset_postdata();
			$output.='</div></div>';
			return $output;
		}
	}
}
add_shortcode('BestSale','yt_bestsale_shortcode');
function page_cate_shortcode( $atts ) {
		extract( shortcode_atts( array(
			'title'         =>'',
			'categories_id'   =>'',
			'el_class' =>'',
			), $atts )
		);
	
		$des_cate = category_description($categories_id);
		$link_cate =  get_category_link($categories_id);
		$title_cate = get_cat_name( $categories_id);
		$thumbnail_id 	= absint( get_woocommerce_term_meta( $categories_id, 'thumbnail_id1', true ));
		$thumb = wp_get_attachment_image( $thumbnail_id, 'full', 0, array( 'class' => 'category-image pull-right' ) );
		
	if($des_cate != '') {
		$output = '<div class="page-cate">';
		$output .= '<div class="widget-caption pull-left">
						<div class="item-title"><h2><a href="'.$link_cate.'" title="'.esc_attr( $title_cate).'">'.esc_html__($title_cate,'sw_woocommerce').'</a></h2></div>
						<div class="item-content">'.$des_cate.'</div>
						<div class="bl_shop_now"><a href="'.$link_cate.'">'.esc_html__('SHOP NOW','sw_woocommerce').'</a></div>
					</div>';
		$output .= '<div class="widget-thumb pull-right"><a href="'.$link_cate.'" title="'.esc_attr( $title_cate).'">'.$thumb.'</a></div>';
		$output .= '</div>';
		return $output;
	}else {
		$output = '<div class="page-cate-no-des">';
		$output .= '<div class="widget-thumb"><a href="'.$link_cate.'" title="'.esc_attr( $title_cate).'">'.$thumb.'</a></div>';
		$output .= '<div class="widget-caption">
						<div class="item-title"><h2><a href="'.$link_cate.'" title="'.esc_attr( $title_cate).'">'.esc_html__($title_cate,'sw_woocommerce').'</a></h2></div>
					</div>';
		$output .= '</div>';
		return $output;
	}
}
add_shortcode('page-cate','page_cate_shortcode');
/*
**	Countdown Banner
*/
function sw_woocommerce_banner_countdown_shortcode($atts){
	extract(shortcode_atts(array(		
		'title'			=> '',
		'description'	=> '',
		'el_class'	=> '',
		'images'		=> '',
		'date'			=> '',
		'url'			=> '',
	),$atts));
	ob_start();
	$bcd_id = 'banner_countdown_'.rand().time();
	$countdown_time = strtotime( $date );
	$date = sw_timezone_offset( $countdown_time );
?>
	<div id="<?php echo esc_attr( $bcd_id ); ?>" class="banner-shortcode <?php echo esc_html__($el_class,'sw_core') ?>">
		<?php if( $title != '') { ?>
			<div class="wp-order-title">
				<div class="order-title">
					<?php
						$titles = strpos($title, ' ');
						$title1 = ($titles !== false) ? '<span>' . substr($title, 0, $titles) . '</span>' .' '. substr($title, $titles + 1): $title ;
						echo '<h2><strong>'. $title1 .'</strong></h2>';
					?>
					<?php echo ( $description != '') ? '<div class="order-desc">'. $description .'</div>' : ''; ?>
				</div>
			</div>
		<?php } ?>
		
		<div class="banner-inner clearfix">
		    <?php 
				if( $images != '' && $url != '' ) :
			?>
			
				<?php 	$img = wp_get_attachment_image( $images, 'full' ); ?>

				<div class="item-banner pull-left"><a href="<?php echo esc_url( $url ); ?>"><?php echo $img ?></a></div>
		<?php 
			endif; 
		?>
		<?php if( $date > time() ) : ?>
			<div class="banner-countdown custom-font" data-date="<?php echo esc_attr( $date ); ?>" data-cdtime="<?php echo esc_attr( $countdown_time ); ?>"></div>
		<?php endif; ?>		</div>
		
	</div>
<?php 
	$content = ob_get_clean();
	return $content;
}
add_shortcode( 'banner_countdown', 'sw_woocommerce_banner_countdown_shortcode' );
/***********************************
*Product Tags                      *
************************************/
function sw_woocommerce_tags_shortcode($atts) {
	extract(shortcode_atts(array(		
		'title'			=> '',
		'el_class'	=> '',
	),$atts));
	$title = $el_class = '';
	$type ='WC_Widget_Product_Tag_Cloud';
	$args = array();
	ob_start();
	the_widget( $type, $atts, $args );
	$content = ob_get_clean();
	return $content;
}

add_shortcode( 'vc_woo_tags', 'sw_woocommerce_tags_shortcode' );