<?php
/**
 * SW WooCommerce Widget Functions
 *
 * Widget related functions and widget registration
 *
 * @author 		SmartAddons
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

include_once( 'sw-widgets/sw-slider-widget.php' );
include_once( 'sw-widgets/sw-slider-countdown-widget.php' );
include_once( 'sw-widgets/sw-woo-tab-category-slider-widget.php' );
include_once( 'sw-widgets/sw-woo-tab-slider-widget.php' );
include_once( 'sw-widgets/sw-related-upsell-widget.php' );
include_once( 'sw-widgets/sw-category-slider-widget.php' );
include_once( 'sw-widgets/sw-woo-tab-category-resplisting-widget.php' );
include_once( 'sw-widgets/sw-woo-tab-child-cate-slider-widget.php' );
include_once( 'sw-widgets/sw-portfolio-product-widget.php' );
include_once( 'sw-widgets/sw-slider-totalsales-widget.php' );
include_once( 'sw-woocommerce-shortcode.php' );


/**
 * Register Widgets
**/
function sw_register_widgets() {
	register_widget( 'sw_woo_slider_widget' );	
	register_widget( 'sw_woo_slider_countdown_widget' );	
	register_widget( 'sw_woo_tab_cat_slider_widget' );
	register_widget( 'sw_woo_tab_slider_widget' );
	register_widget( 'sw_woo_cat_slider_widget' );
	register_widget( 'sw_woo_tab_cat_resplisting_widget' );
	register_widget( 'sw_related_upsell_widget' );
	register_widget( 'sw_woo_tab_child_cate_slider_widget' );
    register_widget( 'sw_portfolio_product_widget' );
    register_widget( 'sw_woott_slider_widget' );
}
add_action( 'widgets_init', 'sw_register_widgets' );

function sw_label_sales(){
	global $product, $post;
	$show_sale = ya_options() ->getCpanelValue('show_sale');
	$forginal_price 	= get_post_meta( $post->ID, '_regular_price', true );	
	$fsale_price 		= get_post_meta( $post->ID, '_sale_price', true );
	if( $fsale_price > 0 && $product->is_on_sale() ){ 
	$sale_off = 100 - ( ( $fsale_price/$forginal_price ) * 100 ); 
?>
		<?php if($show_sale == 'percent' || $show_sale == 'both' ) { ?>
		<div class="sale-off">
			<div class="percent"><?php echo '-' . round( $sale_off ).'%';?></div>
		</div>

		<?php } }
}

/*
** Get timezone offset for countdown
*/
function sw_timezone_offset( $countdowntime ){
	$timeOffset = 0;	
	if( get_option( 'timezone_string' ) != '' ) :
		$timezone = get_option( 'timezone_string' );
		$dateTimeZone = new DateTimeZone( $timezone );
		$dateTime = new DateTime( "now", $dateTimeZone );
		$timeOffset = $dateTimeZone->getOffset( $dateTime );
	else :
		$dateTime = get_option( 'gmt_offset' );
		$dateTime = intval( $dateTime );
		$timeOffset = $dateTime * 3600;
	endif;
	$offset =  ( $timeOffset < 0 ) ? '-' . gmdate( "H:i", abs( $timeOffset ) ) : '+' . gmdate( "H:i", $timeOffset );
	
	$date = date( 'Y/m/d H:i:s', $countdowntime );
	$date1 = new DateTime( $date );
	$cd_date =  $date1->format('Y-m-d H:i:s') . $offset;
	
	return strtotime( $cd_date )*1000;
}

/*
** Check quickview
*/
function sw_quickview(){
	global $product, $post;
	$html='';
	if( function_exists( 'ya_options' ) ){
		$quickview = ya_options()->getCpanelValue( 'product_quickview' );
	}
	if( $quickview ):
	$nonce = wp_create_nonce("ya_quickviewproduct_nonce");
	$link = admin_url('admin-ajax.php?ajax=true&amp;action=ya_quickviewproduct&amp;post_id='. esc_attr( $post->ID ).'&amp;nonce='.esc_attr( $nonce ) );
	$html = '<a href="'. esc_url( $link ) .'" data-fancybox-type="ajax" class="sm_quickview_handler-list fancybox fancybox.ajax">'.apply_filters( 'out_of_stock_add_to_cart_text', esc_html__( 'Quick View ', 'sw_woocommerce' ) ).'</a>';
	endif;	
	return $html;
}

/*
** Sw Ajax URL
*/
function sw_ajax_url(){
	$ajaxurl = version_compare( WC()->version, '2.4', '>=' ) ? WC_AJAX::get_endpoint( "%%endpoint%%" ) : admin_url( 'admin-ajax.php', 'relative' );
	return $ajaxurl;
}

/*
** WooCommerce Compare Version
*/
if( !function_exists( 'sw_woocommerce_version_check' ) ) :
	function sw_woocommerce_version_check( $version = '3.0' ) {
		global $woocommerce;
		if( version_compare( $woocommerce->version, $version, ">=" ) ) {
			return true;
		}else{
			return false;
		}
	}
endif;